﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Web.SessionState;
using DotNet.FrameWork.Data;
using System.Net;
using System.IO;
using System.Text;


namespace HteamDd.Web.ashx
{
    /// <summary>
    /// Dd_Video_Save 的摘要说明
    /// </summary>
    public class Dd_Video_Save : IHttpHandler,IRequiresSessionState
    {
        HaTeam.Dd.BLL.Dd_Video bll = new HaTeam.Dd.BLL.Dd_Video();
        HaTeam.Dd.Model.Dd_Video model = new HaTeam.Dd.Model.Dd_Video();

        HaTeam.Dd.BLL.Dd_Reprint reprint_bll = new HaTeam.Dd.BLL.Dd_Reprint();
        HaTeam.Dd.Model.Dd_Reprint reprint_model = new HaTeam.Dd.Model.Dd_Reprint();

        public void ProcessRequest(HttpContext context)
        {
            if (context.Session["video_mark_ID"] == null && context.Request["state"] != "reship_Video")
            {
                if (context.Request["mark"] == "video_submit")
                {
                    int _num = Dd_VideoInsert(context);
                    context.Response.Write(_num);
                }
            }
            else if (context.Request["state"] == "Video")
            {
                string video_update = "update Dd_Video set Video_Address=@address,Video_Radiourl=@radiourl,Video_Imageurl=@imageurl,Video_Description=@descript,Video_Tag=@tag where Video_ID=@ID";
                SqlParameter[] videos = {
                                        new SqlParameter("@ID",SqlDbType.Int),
                                        new SqlParameter("@address",SqlDbType.NVarChar,100),
                                        new SqlParameter("@radiourl",SqlDbType.NVarChar,100),
                                        new SqlParameter("@imageurl",SqlDbType.NVarChar,150),
                                        new SqlParameter("@descript",SqlDbType.NVarChar,1000),
                                        new SqlParameter("@tag",SqlDbType.VarChar,100)
                                        };
                videos[0].Value = context.Session["video_mark_ID"].ToString();
                videos[1].Value = context.Request["radiourl"].ToString();
                videos[2].Value = "http://player.youku.com/player.php/sid/" + GetPlayUrl(context,context.Request["radiourl"].ToString()) + "/v.swf&amp;isAutoPlay=true";
                videos[3].Value = context.Request["imageurl"].ToString();
                videos[4].Value = context.Request["content"].ToString();
                videos[5].Value =Lable_Prc(context);
                if (DbHelperSQL.ExecuteSql(video_update, videos) != 0)
                {
                    context.Response.Write("1");
                    context.Session.Remove("video_mark_ID");
                }
                else
                {
                    context.Response.Write("-1");
                }
            }
            else if (context.Request["state"] == "reship_Video")
            {
                reprint_model.Reprint_ArticleID = Convert.ToInt32(context.Request["ArticleID"]);
                reprint_model.Reprint_CopyFrom = Convert.ToInt32(context.Request["CopyFrom"]);
                reprint_model.Reprint_OriginID = Convert.ToInt32(context.Request["originID"]);
                reprint_model.Reprint_UserID = Convert.ToInt32(context.Request["userID"]);
                reprint_model.Reprint_Count = 0;
                reprint_model.Reprint_Datetime = System.DateTime.Now;
                reprint_model.Reprint_Delete = 0;
                reprint_model.Reprint_Guid = Guid.NewGuid().ToString();
                reprint_model.Reprint_Lock = 0;
                reprint_model.Reprint_Order = 4;
                reprint_model.Reprint_Remark = null;
                reprint_model.Reprint_State = 0;
                reprint_model.Reprint_type = 4;
                reprint_model.Reprint_UpDatetime = System.DateTime.Now;
                reprint_model.Reprint_Verify = 0;
                int _num = 0;
                try
                {
                    _num = reprint_bll.Add(reprint_model);
                    if (_num!=0)
                    {
                        _num = 1;
                        Dd_VideoInsert(context);
                    }
                }
                catch
                {
                    _num = 0;
                }
                context.Response.Write(_num);
            }
        }

        /// <summary>
        /// 处理视频的播放地址
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public string GetPlayUrl(HttpContext context,string url)
        {
            int index = url.IndexOf("id_", 20, 25);
            if (index == -1)
            {
                string html = context.Session["html"].ToString();
                int list = html.IndexOf("iku://|video", 25000, 10000);
                string sub_id_url = html.Substring(list, 70);
                int index_id_list = sub_id_url.IndexOf("id_", 20, 25);
                return Video_id(sub_id_url, index_id_list);
            }
            else
            {
                return Video_id(url, index);
            }
        }

        private static string Video_id(string url, int id)
        {
            string suburl = url.Substring(id, 21);
            string[] sub = suburl.Split('.');
            string urlname = sub[0];
            string[] urlid = urlname.Split('_');
            return urlid[1];
        }

        /// <summary>
        /// 视频信息的数据库的写入
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private int Dd_VideoInsert(HttpContext context)
        {
            string radiourl = context.Request["radiourl"].ToString();
            string imageurl = context.Request["imageurl"].ToString();
            string playurl = GetPlayUrl(context,radiourl);
            string play = "http://player.youku.com/player.php/sid/" + playurl + "/v.swf&amp;isAutoPlay=true";

            model.User_ID = Convert.ToInt32(context.Request["userID"].ToString());
            model.Video_Address = radiourl;
            model.Video_Imageurl = imageurl;
            model.Video_Radiourl = play;
            model.Video_Description = context.Request["content"].ToString();
            model.Video_Tag = Lable_Prc(context);
            model.Video_Fever = 0;
            model.Video_OriginId = model.User_ID;
            model.Video_Guid = Guid.NewGuid().ToString();
            model.Video_Order = 4;
            model.Video_PublishMode = 1;
            model.Video_PutTop = Convert.ToBoolean(context.Request["check"].ToString());
            model.Video_Datetime = DateTime.Now;
            model.Video_UpDatetime = DateTime.Now;
            model.Video_Verify = 0;
            model.Video_Delete = 0;
            int _num = 0;
            try
            {
                _num = bll.Add(model);
                if (_num != 0)
                {
                    _num = 1;
                }
            }
            catch (Exception ex)
            {
                context.Response.Write(-1);
            }
            return _num;
        }

        /// <summary>
        /// 对标签的处理
        /// </summary>
        /// <param name="context"></param>
        /// <returns></returns>
        private static string Lable_Prc(HttpContext context)
        {
            string lable = "";
            if (context.Request.Params["lable"] == null || context.Request.Params["lable"]=="")
            {  
                lable = context.Request.Params["content"].ToString().Substring(0, 4);               
            }
            else
            {
                lable = context.Request.Params["lable"].ToString();
            }
            return lable;
        }


        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}